### Key components of API
1. **Base URL** contains schemas, host, basePath - e.g. [https://api.example.com/v1](https://api.example.com/v1)
**Scheme/schema** - e.g. https
**Host** - e.g. api.example.dom
**BasePath** - API version - e.g. v1
2. **URL Path** - e.g. /users
Means path is added to Base URL - e.g. [api.example.com/v1/users](http://api.example.com/v1/users)
3. **Query parameters** - e.g. ?role=admin
Parameters that can be passed via
	1.  URL path (/users/{userId}),
	2.  Query string (/users?role=admin),
	3.  Headers (X-CustomHeader: Value) and
	4.  Request body. You can define the parameter types, format, whether they are required or optional, and other details
4. **Operation** - [[CRUD operations on REST APIs]]
5. **Payload** - Most common request/response payloads are in [[JSON Schema]]
	1. **Header** - 
	2. **Body** - 

![[API_Functionality.png]]



### Route vs Endpoints:

-   Endpoints are functions available through the API. This can be things like retrieving the API index, updating a post, or deleting a comment. Endpoints perform a specific function, taking some number of parameters and return data to the client.
-   A route is the “name” you use to access endpoints, used in the URL. **A route can have multiple endpoints associated with it**, and which is used depends on the HTTP verb.
    - E.g. PATCH /quotes/{quoteid} is a route to patch a particular quote resource 
      PATCH /quotes/{quoteid}/contact is an endpoint within the same route to update billing contact of a particular quote resource



![[Pasted image 20230222174514.png]]

